<?php
$this->breadcrumbs = array(
	'Klasy'=>array('/teacher/main/classes'),
	'Klasa '.$model->klasa->nazwa=>array('/teacher/main/class','id'=>$model->idKlasy),
	'Szczegóły ucznia '.$model->imie.' '.$model->nazwisko,
);

$cs = Yii::app()->clientScript;
$cs->registerCssFile(Yii::app()->baseUrl.'/css/ui/themes/smoothness/jquery-ui.min.css');
$cs->registerCoreScript('jquery.ui');
if(isset($_GET['success'])){?>
    <div class="flash-success">
		<?php echo Yii::app()->user->getFlash('accountUpdated'); ?>
	</div>
<?php
}
?>

<?php if(Yii::app()->user->hasFlash('formStatusChanged')): ?>
	<div class="flash-success">
		<?php echo Yii::app()->user->getFlash('formStatusChanged'); ?>
	</div>
<?php endif; ?>

<h1>Szczegóły ucznia <?php echo $model->imieNazwisko ?></h1>

<?php if($model->status == Uzytkownik::USER_STATUS_EXCLUDED): ?>
<p style="color: red">
	<b>Ten użytkownik nie jest już aktywny.</b>
</p>
<?php endif; ?>

<p>
	<b>Uczeń:</b> <?php echo $model->imieNazwisko ?>
</p>

<p>
	<b>Email:</b> <?php echo $model->email ?>
</p>

<p>
	<b>Klasa:</b> <?php echo $model->klasa->nazwa ?>
</p>

<p>
	<b>Firma:</b> <?php echo isset($model->firma) ? $model->firma->nazwa : '<i>brak</i>' ?>
</p>


<!--<a class="buttonS bLightBlue" href="#changeStudentPassword" >Zmień hasło ucznia</a>-->

<?php echo CHtml::link('Zmień hasło ucznia',array('changeStudentPassword', 'id'=>$model->id), array('class'=>'buttonS bLightBlue')); ?>

<div id="tabs">
	<ul>
		<li><a href="#tabs-1">Zlecenia</a></li>
		<li><a href="#tabs-2">Akcje</a></li>
	</ul>
	<div id="tabs-1">
		<?php
			$this->widget('application.modules.teacher.widgets.OrdersList', array(
				'studentId' => $model->id
			));
		?>
	</div>
	<div id="tabs-2">
		<?php if (count($akcje) == 0) echo '<i>Nie rozpoczęto jeszcze żadnej lekcji w klasie ucznia</i>'; ?>
		<ul>
		<?php foreach ($akcje as $lekcja => $akcja) : ?>
		<li>
			<h4>Lekcja #<?php echo $lekcja; ?><br/>
				<span style="font-weight:normal;font-size:75%"><?php echo $akcja[0]->lekcja->scenariusz; ?></span>
			</h4>
			<?php
			$this->widget('zii.widgets.grid.CGridView', array(
				'id'=>'uzytkownik-wykonane-akcje-lekcja-'.$lekcja,
				'dataProvider'=> new CArrayDataProvider($akcja),
				'htmlOptions' => array('class' => 'tDefault'),
				'summaryText' => false,
				'columns'=>array(
					array(
						'name' => 'Nazwa',
						'value' => '($data->czyObowiazkowa?"<b>":"") . str_repeat("&nbsp;&nbsp;&nbsp;", (int)$data->poziom-1) . $data->nazwa . ($data->czyObowiazkowa?"</b>":"") . "<br/>" .
							str_repeat("&nbsp;&nbsp;&nbsp;", (int)$data->poziom-1) . "<i>" . $data->naglowek . "</i>"',
						'type' => 'raw',
						'headerHtmlOptions' => array('style' => 'width:70%')
					),
					array(
						'header'=>'Opcje',
						'value' => '"
							<img " . ($data->czyObowiazkowa?"":"class=\"disabled\" ") . "alt=\"Obowiązkowa\" title=\"Obowiązkowa\" src=\"' . $this->module->assetsUrl . '/images/mandatory.png\" />
							<img " . ($data->czyPracaDomowa?"":"class=\"disabled\" ") . "alt=\"Praca domowa\" title=\"Praca domowa\" src=\"' . $this->module->assetsUrl . '/images/homework.png\" />
							<img " . ($data->czyWiadomosc?"":"class=\"disabled\" ") . "alt=\"Wiadomość\" title=\"Wiadomość\" src=\"' . $this->module->assetsUrl . '/images/message.png\" />
						"',
						'type' => 'raw',
						'headerHtmlOptions' => array('style' => 'width:11%')
					),
					array(
						'name' => 'Wykonano',
						'value' => 'empty($data->dataWykonania)?"":date("Y-m-d H:i", strtotime($data->dataWykonania))',
						'type' => 'raw',
						'headerHtmlOptions' => array('style' => 'width:19%')
					),
				),
			));
			?>
		</li>
		<?php endforeach; ?>
	</ul></div>
</div>

<script type="text/javascript">
(function()
{
	$('#tabs').tabs();
})();
</script>